#!/usr/bin/perl
# split fasta into parts

use 5.010;
use strict;
use warnings;
use Bio::SeqIO;
use Getopt::Long;
use POSIX qw(ceil);

my ($opts,$fa_in,$parts);

$opts=GetOptions("i=s"=>\$fa_in,
				 "p=i"=>\$parts);

my ($num_seqs,$num_seq_per_part);
$num_seqs=`grep -cP '^>' $fa_in`;
chomp($num_seqs);
$num_seq_per_part=ceil($num_seqs/$parts);
print "NSEQS: $num_seqs :\n";
print "NSEQPP: $num_seq_per_part :\n"; 

my ($fa_out_base,$fa_out);
$fa_in=~/(.*?)\.fasta/;
$fa_out_base=$1;
$fa_in=Bio::SeqIO->new(-file=>"<$fa_in",-format=>"fasta");

my ($from,$to,$outstr,$seq);
$from=1;
$to=$num_seq_per_part;
for my $i(1..$parts){
	$fa_out=$fa_out_base.'_p'.$i.'.fasta';
	$outstr=Bio::SeqIO->new(-file=>">$fa_out",-format=>"fasta");
	print " FROM:$from: TO:$to:\n";
	for my $j($from..$to){
		if($seq=$fa_in->next_seq){
			$outstr->write_seq($seq);
		}
	}
	$from=$to+1;
	$to=($from+$num_seq_per_part)-1;
}
