#!/usr/local/bin/perl -w

use strict;
use diagnostics;
use warnings;

use Bio::SearchIO;
use Bio::SearchIO::Writer::HTMLResultWriter;

my $cmd35 = "fasta35 -T4 -w80 -a -m9 -C20 -Q -3 -E100 Sample.prot SampleLight.prot> fasta35.result";
system($cmd35);

my $searchio = new Bio::SearchIO(	-format => 'fasta',
                                 	-file   => "fasta35.result"
);

my $writer = new Bio::SearchIO::Writer::HTMLResultWriter();
my $out = new Bio::SearchIO(	-writer => $writer,
								-file   => ">fasta35.result.html"
);

$out->write_result($searchio->next_result);

my $cmd36 = "fasta36 -T4 -w80 -a -m9 -C20 -Q -3 -E100 Sample.prot SampleLight.prot> fasta36.result";
system($cmd36);

$searchio = new Bio::SearchIO(	-format => 'fasta',
                                 	-file   => "fasta36.result"
);

$writer = new Bio::SearchIO::Writer::HTMLResultWriter();
$out = new Bio::SearchIO(	-writer => $writer,
								-file   => ">fasta36.result.html"
);

$out->write_result($searchio->next_result);

exit;
