package FeatureParser;
use strict;
use base 'Bio::Tools::GFF';
use ModelFeature;

# Grab the next feature that is related to a gene model
# Convert it from 'Bio::Tools::GFF' to 'ModelFeature'
# Skip unrelated features along the way
sub next_model_feature
{
  my($self, $verbose) = @_;
  my $feature;
  do
  {
    $feature = $self->next_feature();
    $feature = ModelFeature->initialize_from_generic($feature);
  } while(defined($feature) and not $feature->valid($verbose));
  return $feature;
}

1;
